package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LabelCategory(name: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.LabelCategory = {
    import LabelCategory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.LabelCategory
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.LabelCategory.ReadOnly =
    zio.aws.rekognition.model.LabelCategory.wrap(buildAwsValue())
}
object LabelCategory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.LabelCategory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.LabelCategory =
      zio.aws.rekognition.model.LabelCategory(name.map(value => value))
    def name: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.LabelCategory
  ) extends zio.aws.rekognition.model.LabelCategory.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.LabelCategory
  ): zio.aws.rekognition.model.LabelCategory.ReadOnly = new Wrapper(impl)
}
