package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LabelAlias(name: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.LabelAlias = {
    import LabelAlias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.LabelAlias
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.LabelAlias.ReadOnly =
    zio.aws.rekognition.model.LabelAlias.wrap(buildAwsValue())
}
object LabelAlias {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.LabelAlias
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.LabelAlias =
      zio.aws.rekognition.model.LabelAlias(name.map(value => value))
    def name: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.LabelAlias
  ) extends zio.aws.rekognition.model.LabelAlias.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.LabelAlias
  ): zio.aws.rekognition.model.LabelAlias.ReadOnly = new Wrapper(impl)
}
