package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FaceDetection(
    timestamp: Optional[Timestamp] = Optional.Absent,
    face: Optional[zio.aws.rekognition.model.FaceDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.FaceDetection = {
    import FaceDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.FaceDetection
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.FaceDetection.ReadOnly =
    zio.aws.rekognition.model.FaceDetection.wrap(buildAwsValue())
}
object FaceDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.FaceDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.FaceDetection =
      zio.aws.rekognition.model.FaceDetection(
        timestamp.map(value => value),
        face.map(value => value.asEditable)
      )
    def timestamp: Optional[Timestamp]
    def face: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.FaceDetection
  ) extends zio.aws.rekognition.model.FaceDetection.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val face: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.face())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.FaceDetection
  ): zio.aws.rekognition.model.FaceDetection.ReadOnly = new Wrapper(impl)
}
