package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectModerationLabelsResponse(
    moderationLabels: Optional[
      Iterable[zio.aws.rekognition.model.ModerationLabel]
    ] = Optional.Absent,
    moderationModelVersion: Optional[String] = Optional.Absent,
    humanLoopActivationOutput: Optional[
      zio.aws.rekognition.model.HumanLoopActivationOutput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse = {
    import DetectModerationLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse
      .builder()
      .optionallyWith(
        moderationLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.moderationLabels)
      .optionallyWith(
        moderationModelVersion.map(value => value: java.lang.String)
      )(_.moderationModelVersion)
      .optionallyWith(
        humanLoopActivationOutput.map(value => value.buildAwsValue())
      )(_.humanLoopActivationOutput)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly =
    zio.aws.rekognition.model.DetectModerationLabelsResponse
      .wrap(buildAwsValue())
}
object DetectModerationLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectModerationLabelsResponse =
      zio.aws.rekognition.model.DetectModerationLabelsResponse(
        moderationLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        moderationModelVersion.map(value => value),
        humanLoopActivationOutput.map(value => value.asEditable)
      )
    def moderationLabels
        : Optional[List[zio.aws.rekognition.model.ModerationLabel.ReadOnly]]
    def moderationModelVersion: Optional[String]
    def humanLoopActivationOutput
        : Optional[zio.aws.rekognition.model.HumanLoopActivationOutput.ReadOnly]
    def getModerationLabels: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ModerationLabel.ReadOnly
    ]] = AwsError.unwrapOptionField("moderationLabels", moderationLabels)
    def getModerationModelVersion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("moderationModelVersion", moderationModelVersion)
    def getHumanLoopActivationOutput: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.HumanLoopActivationOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "humanLoopActivationOutput",
      humanLoopActivationOutput
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse
  ) extends zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly {
    override val moderationLabels
        : Optional[List[zio.aws.rekognition.model.ModerationLabel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderationLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.ModerationLabel.wrap(item)
          }.toList
        )
    override val moderationModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderationModelVersion())
        .map(value => value: String)
    override val humanLoopActivationOutput: Optional[
      zio.aws.rekognition.model.HumanLoopActivationOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLoopActivationOutput())
      .map(value =>
        zio.aws.rekognition.model.HumanLoopActivationOutput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse
  ): zio.aws.rekognition.model.DetectModerationLabelsResponse.ReadOnly =
    new Wrapper(impl)
}
