package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{Percent, UInteger}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DetectLabelsRequest(
    image: zio.aws.rekognition.model.Image,
    maxLabels: Optional[UInteger] = Optional.Absent,
    minConfidence: Optional[Percent] = Optional.Absent,
    features: Optional[
      Iterable[zio.aws.rekognition.model.DetectLabelsFeatureName]
    ] = Optional.Absent,
    settings: Optional[zio.aws.rekognition.model.DetectLabelsSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest = {
    import DetectLabelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
      .builder()
      .image(image.buildAwsValue())
      .optionallyWith(maxLabels.map(value => UInteger.unwrap(value): Integer))(
        _.maxLabels
      )
      .optionallyWith(
        minConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.minConfidence)
      .optionallyWith(
        features.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featuresWithStrings)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsRequest.wrap(buildAwsValue())
}
object DetectLabelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsRequest =
      zio.aws.rekognition.model.DetectLabelsRequest(
        image.asEditable,
        maxLabels.map(value => value),
        minConfidence.map(value => value),
        features.map(value => value),
        settings.map(value => value.asEditable)
      )
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def maxLabels: Optional[UInteger]
    def minConfidence: Optional[Percent]
    def features
        : Optional[List[zio.aws.rekognition.model.DetectLabelsFeatureName]]
    def settings
        : Optional[zio.aws.rekognition.model.DetectLabelsSettings.ReadOnly]
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
    def getMaxLabels: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("maxLabels", maxLabels)
    def getMinConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("minConfidence", minConfidence)
    def getFeatures: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.DetectLabelsFeatureName
    ]] = AwsError.unwrapOptionField("features", features)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ) extends zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
    override val maxLabels: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxLabels())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val minConfidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.minConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val features
        : Optional[List[zio.aws.rekognition.model.DetectLabelsFeatureName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.features())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.DetectLabelsFeatureName.wrap(item)
          }.toList
        )
    override val settings
        : Optional[zio.aws.rekognition.model.DetectLabelsSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          zio.aws.rekognition.model.DetectLabelsSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest
  ): zio.aws.rekognition.model.DetectLabelsRequest.ReadOnly = new Wrapper(impl)
}
