package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteProjectVersionResponse(
    status: Optional[zio.aws.rekognition.model.ProjectVersionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse = {
    import DeleteProjectVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly =
    zio.aws.rekognition.model.DeleteProjectVersionResponse.wrap(buildAwsValue())
}
object DeleteProjectVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteProjectVersionResponse =
      zio.aws.rekognition.model
        .DeleteProjectVersionResponse(status.map(value => value))
    def status: Optional[zio.aws.rekognition.model.ProjectVersionStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ProjectVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse
  ) extends zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly {
    override val status
        : Optional[zio.aws.rekognition.model.ProjectVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rekognition.model.ProjectVersionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse
  ): zio.aws.rekognition.model.DeleteProjectVersionResponse.ReadOnly =
    new Wrapper(impl)
}
