package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  ProjectPolicyRevisionId,
  ProjectPolicyName,
  ProjectArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteProjectPolicyRequest(
    projectArn: ProjectArn,
    policyName: ProjectPolicyName,
    policyRevisionId: Optional[ProjectPolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest = {
    import DeleteProjectPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .policyName(ProjectPolicyName.unwrap(policyName): java.lang.String)
      .optionallyWith(
        policyRevisionId.map(value =>
          ProjectPolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DeleteProjectPolicyRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteProjectPolicyRequest.wrap(buildAwsValue())
}
object DeleteProjectPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteProjectPolicyRequest =
      zio.aws.rekognition.model.DeleteProjectPolicyRequest(
        projectArn,
        policyName,
        policyRevisionId.map(value => value)
      )
    def projectArn: ProjectArn
    def policyName: ProjectPolicyName
    def policyRevisionId: Optional[ProjectPolicyRevisionId]
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getPolicyName: ZIO[Any, Nothing, ProjectPolicyName] =
      ZIO.succeed(policyName)
    def getPolicyRevisionId: ZIO[Any, AwsError, ProjectPolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest
  ) extends zio.aws.rekognition.model.DeleteProjectPolicyRequest.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
    override val policyName: ProjectPolicyName =
      zio.aws.rekognition.model.primitives.ProjectPolicyName(impl.policyName())
    override val policyRevisionId: Optional[ProjectPolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectPolicyRevisionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest
  ): zio.aws.rekognition.model.DeleteProjectPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
