package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait DatasetType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.DatasetType
}
object DatasetType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.DatasetType
  ): zio.aws.rekognition.model.DatasetType = value match {
    case software.amazon.awssdk.services.rekognition.model.DatasetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetType.TRAIN =>
      val r = TRAIN
      r
    case software.amazon.awssdk.services.rekognition.model.DatasetType.TEST =>
      val r = TEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetType =
      software.amazon.awssdk.services.rekognition.model.DatasetType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAIN extends zio.aws.rekognition.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetType =
      software.amazon.awssdk.services.rekognition.model.DatasetType.TRAIN
  }
  case object TEST extends zio.aws.rekognition.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.DatasetType =
      software.amazon.awssdk.services.rekognition.model.DatasetType.TEST
  }
}
