package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessorOutput(
    kinesisDataStream: Optional[zio.aws.rekognition.model.KinesisDataStream] =
      Optional.Absent,
    s3Destination: Optional[zio.aws.rekognition.model.S3Destination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput = {
    import StreamProcessorOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
      .builder()
      .optionallyWith(kinesisDataStream.map(value => value.buildAwsValue()))(
        _.kinesisDataStream
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly =
    zio.aws.rekognition.model.StreamProcessorOutput.wrap(buildAwsValue())
}
object StreamProcessorOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessorOutput =
      zio.aws.rekognition.model.StreamProcessorOutput(
        kinesisDataStream.map(value => value.asEditable),
        s3Destination.map(value => value.asEditable)
      )
    def kinesisDataStream
        : Optional[zio.aws.rekognition.model.KinesisDataStream.ReadOnly]
    def s3Destination
        : Optional[zio.aws.rekognition.model.S3Destination.ReadOnly]
    def getKinesisDataStream: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.KinesisDataStream.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisDataStream", kinesisDataStream)
    def getS3Destination
        : ZIO[Any, AwsError, zio.aws.rekognition.model.S3Destination.ReadOnly] =
      AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
  ) extends zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly {
    override val kinesisDataStream
        : Optional[zio.aws.rekognition.model.KinesisDataStream.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisDataStream())
        .map(value => zio.aws.rekognition.model.KinesisDataStream.wrap(value))
    override val s3Destination
        : Optional[zio.aws.rekognition.model.S3Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.rekognition.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput
  ): zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly = new Wrapper(
    impl
  )
}
