package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamProcessor(
    name: Optional[StreamProcessorName] = Optional.Absent,
    status: Optional[zio.aws.rekognition.model.StreamProcessorStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessor = {
    import StreamProcessor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessor
      .builder()
      .optionallyWith(
        name.map(value => StreamProcessorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StreamProcessor.ReadOnly =
    zio.aws.rekognition.model.StreamProcessor.wrap(buildAwsValue())
}
object StreamProcessor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessor =
      zio.aws.rekognition.model
        .StreamProcessor(name.map(value => value), status.map(value => value))
    def name: Optional[StreamProcessorName]
    def status: Optional[zio.aws.rekognition.model.StreamProcessorStatus]
    def getName: ZIO[Any, AwsError, StreamProcessorName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.StreamProcessorStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessor
  ) extends zio.aws.rekognition.model.StreamProcessor.ReadOnly {
    override val name: Optional[StreamProcessorName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.rekognition.model.primitives.StreamProcessorName(value)
      )
    override val status
        : Optional[zio.aws.rekognition.model.StreamProcessorStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.rekognition.model.StreamProcessorStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessor
  ): zio.aws.rekognition.model.StreamProcessor.ReadOnly = new Wrapper(impl)
}
