package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartStreamProcessorRequest(
    name: StreamProcessorName,
    startSelector: Optional[
      zio.aws.rekognition.model.StreamProcessingStartSelector
    ] = Optional.Absent,
    stopSelector: Optional[
      zio.aws.rekognition.model.StreamProcessingStopSelector
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest = {
    import StartStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
      .builder()
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .optionallyWith(startSelector.map(value => value.buildAwsValue()))(
        _.startSelector
      )
      .optionallyWith(stopSelector.map(value => value.buildAwsValue()))(
        _.stopSelector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.StartStreamProcessorRequest.wrap(buildAwsValue())
}
object StartStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartStreamProcessorRequest =
      zio.aws.rekognition.model.StartStreamProcessorRequest(
        name,
        startSelector.map(value => value.asEditable),
        stopSelector.map(value => value.asEditable)
      )
    def name: StreamProcessorName
    def startSelector: Optional[
      zio.aws.rekognition.model.StreamProcessingStartSelector.ReadOnly
    ]
    def stopSelector: Optional[
      zio.aws.rekognition.model.StreamProcessingStopSelector.ReadOnly
    ]
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
    def getStartSelector: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessingStartSelector.ReadOnly
    ] = AwsError.unwrapOptionField("startSelector", startSelector)
    def getStopSelector: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessingStopSelector.ReadOnly
    ] = AwsError.unwrapOptionField("stopSelector", stopSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
  ) extends zio.aws.rekognition.model.StartStreamProcessorRequest.ReadOnly {
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
    override val startSelector: Optional[
      zio.aws.rekognition.model.StreamProcessingStartSelector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.startSelector())
      .map(value =>
        zio.aws.rekognition.model.StreamProcessingStartSelector.wrap(value)
      )
    override val stopSelector: Optional[
      zio.aws.rekognition.model.StreamProcessingStopSelector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stopSelector())
      .map(value =>
        zio.aws.rekognition.model.StreamProcessingStopSelector.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest
  ): zio.aws.rekognition.model.StartStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
