package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  ListProjectPoliciesPageSize,
  ExtendedPaginationToken,
  ProjectArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProjectPoliciesRequest(
    projectArn: ProjectArn,
    nextToken: Optional[ExtendedPaginationToken] = Optional.Absent,
    maxResults: Optional[ListProjectPoliciesPageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest = {
    import ListProjectPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListProjectPoliciesPageSize.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.ListProjectPoliciesRequest.ReadOnly =
    zio.aws.rekognition.model.ListProjectPoliciesRequest.wrap(buildAwsValue())
}
object ListProjectPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListProjectPoliciesRequest =
      zio.aws.rekognition.model.ListProjectPoliciesRequest(
        projectArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectArn: ProjectArn
    def nextToken: Optional[ExtendedPaginationToken]
    def maxResults: Optional[ListProjectPoliciesPageSize]
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListProjectPoliciesPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest
  ) extends zio.aws.rekognition.model.ListProjectPoliciesRequest.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
    override val nextToken: Optional[ExtendedPaginationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
        )
    override val maxResults: Optional[ListProjectPoliciesPageSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.rekognition.model.primitives
            .ListProjectPoliciesPageSize(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest
  ): zio.aws.rekognition.model.ListProjectPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
