package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait LabelDetectionFeatureName {
  def unwrap: software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName
}
object LabelDetectionFeatureName {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName
  ): zio.aws.rekognition.model.LabelDetectionFeatureName = value match {
    case software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName.GENERAL_LABELS =>
      val r = GENERAL_LABELS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.LabelDetectionFeatureName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName =
      software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName.UNKNOWN_TO_SDK_VERSION
  }
  case object GENERAL_LABELS
      extends zio.aws.rekognition.model.LabelDetectionFeatureName {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName =
      software.amazon.awssdk.services.rekognition.model.LabelDetectionFeatureName.GENERAL_LABELS
  }
}
