package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPersonTrackingResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    videoMetadata: Optional[zio.aws.rekognition.model.VideoMetadata] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    persons: Optional[Iterable[zio.aws.rekognition.model.PersonDetection]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse = {
    import GetPersonTrackingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        persons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.persons)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly =
    zio.aws.rekognition.model.GetPersonTrackingResponse.wrap(buildAwsValue())
}
object GetPersonTrackingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetPersonTrackingResponse =
      zio.aws.rekognition.model.GetPersonTrackingResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        persons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def persons
        : Optional[List[zio.aws.rekognition.model.PersonDetection.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPersons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.PersonDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("persons", persons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
  ) extends zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val persons
        : Optional[List[zio.aws.rekognition.model.PersonDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.persons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.PersonDetection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse
  ): zio.aws.rekognition.model.GetPersonTrackingResponse.ReadOnly = new Wrapper(
    impl
  )
}
