package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FaceRecord(
    face: Optional[zio.aws.rekognition.model.Face] = Optional.Absent,
    faceDetail: Optional[zio.aws.rekognition.model.FaceDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.FaceRecord = {
    import FaceRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.FaceRecord
      .builder()
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .optionallyWith(faceDetail.map(value => value.buildAwsValue()))(
        _.faceDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.FaceRecord.ReadOnly =
    zio.aws.rekognition.model.FaceRecord.wrap(buildAwsValue())
}
object FaceRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.FaceRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.FaceRecord =
      zio.aws.rekognition.model.FaceRecord(
        face.map(value => value.asEditable),
        faceDetail.map(value => value.asEditable)
      )
    def face: Optional[zio.aws.rekognition.model.Face.ReadOnly]
    def faceDetail: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def getFace: ZIO[Any, AwsError, zio.aws.rekognition.model.Face.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
    def getFaceDetail
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("faceDetail", faceDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.FaceRecord
  ) extends zio.aws.rekognition.model.FaceRecord.ReadOnly {
    override val face: Optional[zio.aws.rekognition.model.Face.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.face())
        .map(value => zio.aws.rekognition.model.Face.wrap(value))
    override val faceDetail
        : Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceDetail())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.FaceRecord
  ): zio.aws.rekognition.model.FaceRecord.ReadOnly = new Wrapper(impl)
}
