package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectLabelsResponse(
    labels: Optional[Iterable[zio.aws.rekognition.model.Label]] =
      Optional.Absent,
    orientationCorrection: Optional[
      zio.aws.rekognition.model.OrientationCorrection
    ] = Optional.Absent,
    labelModelVersion: Optional[String] = Optional.Absent,
    imageProperties: Optional[
      zio.aws.rekognition.model.DetectLabelsImageProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse = {
    import DetectLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
      .builder()
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(orientationCorrection.map(value => value.unwrap))(
        _.orientationCorrection
      )
      .optionallyWith(labelModelVersion.map(value => value: java.lang.String))(
        _.labelModelVersion
      )
      .optionallyWith(imageProperties.map(value => value.buildAwsValue()))(
        _.imageProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsResponse.wrap(buildAwsValue())
}
object DetectLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsResponse =
      zio.aws.rekognition.model.DetectLabelsResponse(
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orientationCorrection.map(value => value),
        labelModelVersion.map(value => value),
        imageProperties.map(value => value.asEditable)
      )
    def labels: Optional[List[zio.aws.rekognition.model.Label.ReadOnly]]
    def orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection]
    def labelModelVersion: Optional[String]
    def imageProperties: Optional[
      zio.aws.rekognition.model.DetectLabelsImageProperties.ReadOnly
    ]
    def getLabels
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Label.ReadOnly]] =
      AwsError.unwrapOptionField("labels", labels)
    def getOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField("orientationCorrection", orientationCorrection)
    def getLabelModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("labelModelVersion", labelModelVersion)
    def getImageProperties: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsImageProperties.ReadOnly
    ] = AwsError.unwrapOptionField("imageProperties", imageProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
  ) extends zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly {
    override val labels
        : Optional[List[zio.aws.rekognition.model.Label.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Label.wrap(item)
          }.toList
        )
    override val orientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orientationCorrection())
        .map(value =>
          zio.aws.rekognition.model.OrientationCorrection.wrap(value)
        )
    override val labelModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.labelModelVersion())
      .map(value => value: String)
    override val imageProperties: Optional[
      zio.aws.rekognition.model.DetectLabelsImageProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageProperties())
      .map(value =>
        zio.aws.rekognition.model.DetectLabelsImageProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
  ): zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly = new Wrapper(impl)
}
