package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectLabelsImageQuality(
    brightness: Optional[Float] = Optional.Absent,
    sharpness: Optional[Float] = Optional.Absent,
    contrast: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsImageQuality = {
    import DetectLabelsImageQuality.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImageQuality
      .builder()
      .optionallyWith(brightness.map(value => value: java.lang.Float))(
        _.brightness
      )
      .optionallyWith(sharpness.map(value => value: java.lang.Float))(
        _.sharpness
      )
      .optionallyWith(contrast.map(value => value: java.lang.Float))(_.contrast)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsImageQuality.wrap(buildAwsValue())
}
object DetectLabelsImageQuality {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImageQuality
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsImageQuality =
      zio.aws.rekognition.model.DetectLabelsImageQuality(
        brightness.map(value => value),
        sharpness.map(value => value),
        contrast.map(value => value)
      )
    def brightness: Optional[Float]
    def sharpness: Optional[Float]
    def contrast: Optional[Float]
    def getBrightness: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("brightness", brightness)
    def getSharpness: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("sharpness", sharpness)
    def getContrast: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("contrast", contrast)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImageQuality
  ) extends zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly {
    override val brightness: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.brightness())
      .map(value => value: Float)
    override val sharpness: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.sharpness())
      .map(value => value: Float)
    override val contrast: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.contrast())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImageQuality
  ): zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly = new Wrapper(
    impl
  )
}
