package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectLabelsImageBackground(
    quality: Optional[zio.aws.rekognition.model.DetectLabelsImageQuality] =
      Optional.Absent,
    dominantColors: Optional[
      Iterable[zio.aws.rekognition.model.DominantColor]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsImageBackground = {
    import DetectLabelsImageBackground.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImageBackground
      .builder()
      .optionallyWith(quality.map(value => value.buildAwsValue()))(_.quality)
      .optionallyWith(
        dominantColors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dominantColors)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectLabelsImageBackground.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsImageBackground.wrap(buildAwsValue())
}
object DetectLabelsImageBackground {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsImageBackground
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsImageBackground =
      zio.aws.rekognition.model.DetectLabelsImageBackground(
        quality.map(value => value.asEditable),
        dominantColors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quality
        : Optional[zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly]
    def dominantColors
        : Optional[List[zio.aws.rekognition.model.DominantColor.ReadOnly]]
    def getQuality: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly
    ] = AwsError.unwrapOptionField("quality", quality)
    def getDominantColors: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.DominantColor.ReadOnly
    ]] = AwsError.unwrapOptionField("dominantColors", dominantColors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImageBackground
  ) extends zio.aws.rekognition.model.DetectLabelsImageBackground.ReadOnly {
    override val quality: Optional[
      zio.aws.rekognition.model.DetectLabelsImageQuality.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.quality())
      .map(value =>
        zio.aws.rekognition.model.DetectLabelsImageQuality.wrap(value)
      )
    override val dominantColors
        : Optional[List[zio.aws.rekognition.model.DominantColor.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dominantColors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.DominantColor.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsImageBackground
  ): zio.aws.rekognition.model.DetectLabelsImageBackground.ReadOnly =
    new Wrapper(impl)
}
