package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(projectName: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateProjectRequest.ReadOnly =
    zio.aws.rekognition.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateProjectRequest =
      zio.aws.rekognition.model.CreateProjectRequest(projectName)
    def projectName: ProjectName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectRequest
  ) extends zio.aws.rekognition.model.CreateProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.rekognition.model.primitives.ProjectName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectRequest
  ): zio.aws.rekognition.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
