package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartFaceSearchResponse(
    jobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse = {
    import StartFaceSearchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly =
    zio.aws.rekognition.model.StartFaceSearchResponse.wrap(buildAwsValue())
}
object StartFaceSearchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartFaceSearchResponse =
      zio.aws.rekognition.model
        .StartFaceSearchResponse(jobId.map(value => value))
    def jobId: Optional[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse
  ) extends zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.rekognition.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse
  ): zio.aws.rekognition.model.StartFaceSearchResponse.ReadOnly = new Wrapper(
    impl
  )
}
