package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  ProjectPolicyDocument,
  ProjectPolicyRevisionId,
  ProjectPolicyName,
  ProjectArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutProjectPolicyRequest(
    projectArn: ProjectArn,
    policyName: ProjectPolicyName,
    policyRevisionId: Optional[ProjectPolicyRevisionId] = Optional.Absent,
    policyDocument: ProjectPolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest = {
    import PutProjectPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .policyName(ProjectPolicyName.unwrap(policyName): java.lang.String)
      .optionallyWith(
        policyRevisionId.map(value =>
          ProjectPolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .policyDocument(
        ProjectPolicyDocument.unwrap(policyDocument): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.PutProjectPolicyRequest.ReadOnly =
    zio.aws.rekognition.model.PutProjectPolicyRequest.wrap(buildAwsValue())
}
object PutProjectPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.PutProjectPolicyRequest =
      zio.aws.rekognition.model.PutProjectPolicyRequest(
        projectArn,
        policyName,
        policyRevisionId.map(value => value),
        policyDocument
      )
    def projectArn: ProjectArn
    def policyName: ProjectPolicyName
    def policyRevisionId: Optional[ProjectPolicyRevisionId]
    def policyDocument: ProjectPolicyDocument
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
    def getPolicyName: ZIO[Any, Nothing, ProjectPolicyName] =
      ZIO.succeed(policyName)
    def getPolicyRevisionId: ZIO[Any, AwsError, ProjectPolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
    def getPolicyDocument: ZIO[Any, Nothing, ProjectPolicyDocument] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest
  ) extends zio.aws.rekognition.model.PutProjectPolicyRequest.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
    override val policyName: ProjectPolicyName =
      zio.aws.rekognition.model.primitives.ProjectPolicyName(impl.policyName())
    override val policyRevisionId: Optional[ProjectPolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectPolicyRevisionId(value)
        )
    override val policyDocument: ProjectPolicyDocument =
      zio.aws.rekognition.model.primitives
        .ProjectPolicyDocument(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest
  ): zio.aws.rekognition.model.PutProjectPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
