package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{PageSize, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCollectionsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest = {
    import ListCollectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListCollectionsRequest.ReadOnly =
    zio.aws.rekognition.model.ListCollectionsRequest.wrap(buildAwsValue())
}
object ListCollectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListCollectionsRequest =
      zio.aws.rekognition.model.ListCollectionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PageSize]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest
  ) extends zio.aws.rekognition.model.ListCollectionsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest
  ): zio.aws.rekognition.model.ListCollectionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
