package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  KinesisVideoStreamFragmentNumber,
  ULong
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KinesisVideoStreamStartSelector(
    producerTimestamp: Optional[ULong] = Optional.Absent,
    fragmentNumber: Optional[KinesisVideoStreamFragmentNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.KinesisVideoStreamStartSelector = {
    import KinesisVideoStreamStartSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.KinesisVideoStreamStartSelector
      .builder()
      .optionallyWith(
        producerTimestamp.map(value => ULong.unwrap(value): java.lang.Long)
      )(_.producerTimestamp)
      .optionallyWith(
        fragmentNumber.map(value =>
          KinesisVideoStreamFragmentNumber.unwrap(value): java.lang.String
        )
      )(_.fragmentNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.KinesisVideoStreamStartSelector.ReadOnly =
    zio.aws.rekognition.model.KinesisVideoStreamStartSelector
      .wrap(buildAwsValue())
}
object KinesisVideoStreamStartSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.KinesisVideoStreamStartSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.KinesisVideoStreamStartSelector =
      zio.aws.rekognition.model.KinesisVideoStreamStartSelector(
        producerTimestamp.map(value => value),
        fragmentNumber.map(value => value)
      )
    def producerTimestamp: Optional[ULong]
    def fragmentNumber: Optional[KinesisVideoStreamFragmentNumber]
    def getProducerTimestamp: ZIO[Any, AwsError, ULong] =
      AwsError.unwrapOptionField("producerTimestamp", producerTimestamp)
    def getFragmentNumber
        : ZIO[Any, AwsError, KinesisVideoStreamFragmentNumber] =
      AwsError.unwrapOptionField("fragmentNumber", fragmentNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.KinesisVideoStreamStartSelector
  ) extends zio.aws.rekognition.model.KinesisVideoStreamStartSelector.ReadOnly {
    override val producerTimestamp: Optional[ULong] = zio.aws.core.internal
      .optionalFromNullable(impl.producerTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.ULong(value))
    override val fragmentNumber: Optional[KinesisVideoStreamFragmentNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentNumber())
        .map(value =>
          zio.aws.rekognition.model.primitives
            .KinesisVideoStreamFragmentNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.KinesisVideoStreamStartSelector
  ): zio.aws.rekognition.model.KinesisVideoStreamStartSelector.ReadOnly =
    new Wrapper(impl)
}
