package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{Percent, UInteger}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DominantColor(
    red: Optional[UInteger] = Optional.Absent,
    blue: Optional[UInteger] = Optional.Absent,
    green: Optional[UInteger] = Optional.Absent,
    hexCode: Optional[String] = Optional.Absent,
    cssColor: Optional[String] = Optional.Absent,
    simplifiedColor: Optional[String] = Optional.Absent,
    pixelPercent: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DominantColor = {
    import DominantColor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DominantColor
      .builder()
      .optionallyWith(red.map(value => UInteger.unwrap(value): Integer))(_.red)
      .optionallyWith(blue.map(value => UInteger.unwrap(value): Integer))(
        _.blue
      )
      .optionallyWith(green.map(value => UInteger.unwrap(value): Integer))(
        _.green
      )
      .optionallyWith(hexCode.map(value => value: java.lang.String))(_.hexCode)
      .optionallyWith(cssColor.map(value => value: java.lang.String))(
        _.cssColor
      )
      .optionallyWith(simplifiedColor.map(value => value: java.lang.String))(
        _.simplifiedColor
      )
      .optionallyWith(
        pixelPercent.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.pixelPercent)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DominantColor.ReadOnly =
    zio.aws.rekognition.model.DominantColor.wrap(buildAwsValue())
}
object DominantColor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DominantColor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DominantColor =
      zio.aws.rekognition.model.DominantColor(
        red.map(value => value),
        blue.map(value => value),
        green.map(value => value),
        hexCode.map(value => value),
        cssColor.map(value => value),
        simplifiedColor.map(value => value),
        pixelPercent.map(value => value)
      )
    def red: Optional[UInteger]
    def blue: Optional[UInteger]
    def green: Optional[UInteger]
    def hexCode: Optional[String]
    def cssColor: Optional[String]
    def simplifiedColor: Optional[String]
    def pixelPercent: Optional[Percent]
    def getRed: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("red", red)
    def getBlue: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("blue", blue)
    def getGreen: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("green", green)
    def getHexCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hexCode", hexCode)
    def getCssColor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cssColor", cssColor)
    def getSimplifiedColor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("simplifiedColor", simplifiedColor)
    def getPixelPercent: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("pixelPercent", pixelPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DominantColor
  ) extends zio.aws.rekognition.model.DominantColor.ReadOnly {
    override val red: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.red())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val blue: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.blue())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val green: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.green())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
    override val hexCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hexCode())
      .map(value => value: String)
    override val cssColor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cssColor())
      .map(value => value: String)
    override val simplifiedColor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.simplifiedColor())
      .map(value => value: String)
    override val pixelPercent: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.pixelPercent())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DominantColor
  ): zio.aws.rekognition.model.DominantColor.ReadOnly = new Wrapper(impl)
}
