package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectTextResponse(
    textDetections: Optional[
      Iterable[zio.aws.rekognition.model.TextDetection]
    ] = Optional.Absent,
    textModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectTextResponse = {
    import DetectTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectTextResponse
      .builder()
      .optionallyWith(
        textDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textDetections)
      .optionallyWith(textModelVersion.map(value => value: java.lang.String))(
        _.textModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectTextResponse.ReadOnly =
    zio.aws.rekognition.model.DetectTextResponse.wrap(buildAwsValue())
}
object DetectTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectTextResponse =
      zio.aws.rekognition.model.DetectTextResponse(
        textDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        textModelVersion.map(value => value)
      )
    def textDetections
        : Optional[List[zio.aws.rekognition.model.TextDetection.ReadOnly]]
    def textModelVersion: Optional[String]
    def getTextDetections: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.TextDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("textDetections", textDetections)
    def getTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("textModelVersion", textModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextResponse
  ) extends zio.aws.rekognition.model.DetectTextResponse.ReadOnly {
    override val textDetections
        : Optional[List[zio.aws.rekognition.model.TextDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textDetections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.TextDetection.wrap(item)
          }.toList
        )
    override val textModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.textModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectTextResponse
  ): zio.aws.rekognition.model.DetectTextResponse.ReadOnly = new Wrapper(impl)
}
