package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ExtendedPaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProjectsResponse(
    projectDescriptions: Optional[
      Iterable[zio.aws.rekognition.model.ProjectDescription]
    ] = Optional.Absent,
    nextToken: Optional[ExtendedPaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse = {
    import DescribeProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse
      .builder()
      .optionallyWith(
        projectDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projectDescriptions)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DescribeProjectsResponse.ReadOnly =
    zio.aws.rekognition.model.DescribeProjectsResponse.wrap(buildAwsValue())
}
object DescribeProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeProjectsResponse =
      zio.aws.rekognition.model.DescribeProjectsResponse(
        projectDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def projectDescriptions
        : Optional[List[zio.aws.rekognition.model.ProjectDescription.ReadOnly]]
    def nextToken: Optional[ExtendedPaginationToken]
    def getProjectDescriptions: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ProjectDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("projectDescriptions", projectDescriptions)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse
  ) extends zio.aws.rekognition.model.DescribeProjectsResponse.ReadOnly {
    override val projectDescriptions: Optional[
      List[zio.aws.rekognition.model.ProjectDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projectDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ProjectDescription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[ExtendedPaginationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse
  ): zio.aws.rekognition.model.DescribeProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
