package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.UInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeleteCollectionResponse(
    statusCode: Optional[UInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse = {
    import DeleteCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse
      .builder()
      .optionallyWith(statusCode.map(value => UInteger.unwrap(value): Integer))(
        _.statusCode
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly =
    zio.aws.rekognition.model.DeleteCollectionResponse.wrap(buildAwsValue())
}
object DeleteCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteCollectionResponse =
      zio.aws.rekognition.model
        .DeleteCollectionResponse(statusCode.map(value => value))
    def statusCode: Optional[UInteger]
    def getStatusCode: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse
  ) extends zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly {
    override val statusCode: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => zio.aws.rekognition.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse
  ): zio.aws.rekognition.model.DeleteCollectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
