package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComparedFace(
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    landmarks: Optional[Iterable[zio.aws.rekognition.model.Landmark]] =
      Optional.Absent,
    pose: Optional[zio.aws.rekognition.model.Pose] = Optional.Absent,
    quality: Optional[zio.aws.rekognition.model.ImageQuality] = Optional.Absent,
    emotions: Optional[Iterable[zio.aws.rekognition.model.Emotion]] =
      Optional.Absent,
    smile: Optional[zio.aws.rekognition.model.Smile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ComparedFace = {
    import ComparedFace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ComparedFace
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(
        landmarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.landmarks)
      .optionallyWith(pose.map(value => value.buildAwsValue()))(_.pose)
      .optionallyWith(quality.map(value => value.buildAwsValue()))(_.quality)
      .optionallyWith(
        emotions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emotions)
      .optionallyWith(smile.map(value => value.buildAwsValue()))(_.smile)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ComparedFace.ReadOnly =
    zio.aws.rekognition.model.ComparedFace.wrap(buildAwsValue())
}
object ComparedFace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ComparedFace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ComparedFace =
      zio.aws.rekognition.model.ComparedFace(
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value),
        landmarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pose.map(value => value.asEditable),
        quality.map(value => value.asEditable),
        emotions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        smile.map(value => value.asEditable)
      )
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Optional[Percent]
    def landmarks: Optional[List[zio.aws.rekognition.model.Landmark.ReadOnly]]
    def pose: Optional[zio.aws.rekognition.model.Pose.ReadOnly]
    def quality: Optional[zio.aws.rekognition.model.ImageQuality.ReadOnly]
    def emotions: Optional[List[zio.aws.rekognition.model.Emotion.ReadOnly]]
    def smile: Optional[zio.aws.rekognition.model.Smile.ReadOnly]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getLandmarks: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.Landmark.ReadOnly
    ]] = AwsError.unwrapOptionField("landmarks", landmarks)
    def getPose: ZIO[Any, AwsError, zio.aws.rekognition.model.Pose.ReadOnly] =
      AwsError.unwrapOptionField("pose", pose)
    def getQuality
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ImageQuality.ReadOnly] =
      AwsError.unwrapOptionField("quality", quality)
    def getEmotions
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Emotion.ReadOnly]] =
      AwsError.unwrapOptionField("emotions", emotions)
    def getSmile: ZIO[Any, AwsError, zio.aws.rekognition.model.Smile.ReadOnly] =
      AwsError.unwrapOptionField("smile", smile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ComparedFace
  ) extends zio.aws.rekognition.model.ComparedFace.ReadOnly {
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val landmarks
        : Optional[List[zio.aws.rekognition.model.Landmark.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.landmarks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Landmark.wrap(item)
          }.toList
        )
    override val pose: Optional[zio.aws.rekognition.model.Pose.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pose())
        .map(value => zio.aws.rekognition.model.Pose.wrap(value))
    override val quality
        : Optional[zio.aws.rekognition.model.ImageQuality.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quality())
        .map(value => zio.aws.rekognition.model.ImageQuality.wrap(value))
    override val emotions
        : Optional[List[zio.aws.rekognition.model.Emotion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emotions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Emotion.wrap(item)
          }.toList
        )
    override val smile: Optional[zio.aws.rekognition.model.Smile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smile())
        .map(value => zio.aws.rekognition.model.Smile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ComparedFace
  ): zio.aws.rekognition.model.ComparedFace.ReadOnly = new Wrapper(impl)
}
