package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, RekognitionUniqueId, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CelebrityDetail(
    urls: Optional[Iterable[Url]] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    id: Optional[RekognitionUniqueId] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    face: Optional[zio.aws.rekognition.model.FaceDetail] = Optional.Absent,
    knownGender: Optional[zio.aws.rekognition.model.KnownGender] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CelebrityDetail = {
    import CelebrityDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CelebrityDetail
      .builder()
      .optionallyWith(
        urls.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.urls)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        id.map(value => RekognitionUniqueId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .optionallyWith(knownGender.map(value => value.buildAwsValue()))(
        _.knownGender
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CelebrityDetail.ReadOnly =
    zio.aws.rekognition.model.CelebrityDetail.wrap(buildAwsValue())
}
object CelebrityDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CelebrityDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CelebrityDetail =
      zio.aws.rekognition.model.CelebrityDetail(
        urls.map(value => value),
        name.map(value => value),
        id.map(value => value),
        confidence.map(value => value),
        boundingBox.map(value => value.asEditable),
        face.map(value => value.asEditable),
        knownGender.map(value => value.asEditable)
      )
    def urls: Optional[List[Url]]
    def name: Optional[String]
    def id: Optional[RekognitionUniqueId]
    def confidence: Optional[Percent]
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def face: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def knownGender: Optional[zio.aws.rekognition.model.KnownGender.ReadOnly]
    def getUrls: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("urls", urls)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, RekognitionUniqueId] =
      AwsError.unwrapOptionField("id", id)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
    def getKnownGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.KnownGender.ReadOnly] =
      AwsError.unwrapOptionField("knownGender", knownGender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CelebrityDetail
  ) extends zio.aws.rekognition.model.CelebrityDetail.ReadOnly {
    override val urls: Optional[List[Url]] = zio.aws.core.internal
      .optionalFromNullable(impl.urls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.Url(item)
        }.toList
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val id: Optional[RekognitionUniqueId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.rekognition.model.primitives.RekognitionUniqueId(value)
      )
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val face: Optional[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.face())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
    override val knownGender
        : Optional[zio.aws.rekognition.model.KnownGender.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.knownGender())
        .map(value => zio.aws.rekognition.model.KnownGender.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CelebrityDetail
  ): zio.aws.rekognition.model.CelebrityDetail.ReadOnly = new Wrapper(impl)
}
