package zio.aws.rekognition
import zio.aws.rekognition.model.primitives.PersonIndex.Type
import java.time.Instant
import zio.Chunk
import zio.aws.rekognition.model.primitives.{
  HumanLoopActivationReason,
  FaceId,
  ProjectName,
  Url,
  TagValue,
  CollectionId,
  DatasetEntry,
  DatasetLabel,
  UInteger,
  VersionName,
  ConnectedHomeLabel,
  TagKey
}
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object BoundingBoxHeight extends Subtype[Float]
    type BoundingBoxHeight =
      zio.aws.rekognition.model.primitives.BoundingBoxHeight.Type
    object BoundingBoxWidth extends Subtype[Float]
    type BoundingBoxWidth =
      zio.aws.rekognition.model.primitives.BoundingBoxWidth.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.rekognition.model.primitives.ClientRequestToken.Type
    object CollectionId extends Subtype[String]
    type CollectionId = zio.aws.rekognition.model.primitives.CollectionId.Type
    object ConnectedHomeLabel extends Subtype[String]
    type ConnectedHomeLabel =
      zio.aws.rekognition.model.primitives.ConnectedHomeLabel.Type
    object DatasetArn extends Subtype[String]
    type DatasetArn = zio.aws.rekognition.model.primitives.DatasetArn.Type
    object DatasetEntry extends Subtype[String]
    type DatasetEntry = zio.aws.rekognition.model.primitives.DatasetEntry.Type
    object DatasetLabel extends Subtype[String]
    type DatasetLabel = zio.aws.rekognition.model.primitives.DatasetLabel.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.rekognition.model.primitives.DateTime.Type
    object Degree extends Subtype[Float]
    type Degree = zio.aws.rekognition.model.primitives.Degree.Type
    object ExtendedPaginationToken extends Subtype[String]
    type ExtendedPaginationToken =
      zio.aws.rekognition.model.primitives.ExtendedPaginationToken.Type
    object ExternalImageId extends Subtype[String]
    type ExternalImageId =
      zio.aws.rekognition.model.primitives.ExternalImageId.Type
    object FaceId extends Subtype[String]
    type FaceId = zio.aws.rekognition.model.primitives.FaceId.Type
    object FlowDefinitionArn extends Subtype[String]
    type FlowDefinitionArn =
      zio.aws.rekognition.model.primitives.FlowDefinitionArn.Type
    object GroundTruthBlob extends Subtype[Chunk[Byte]]
    type GroundTruthBlob =
      zio.aws.rekognition.model.primitives.GroundTruthBlob.Type
    object HasErrors extends Subtype[Boolean]
    type HasErrors = zio.aws.rekognition.model.primitives.HasErrors.Type
    object HumanLoopActivationConditionsEvaluationResults
        extends Subtype[String]
    type HumanLoopActivationConditionsEvaluationResults =
      zio.aws.rekognition.model.primitives.HumanLoopActivationConditionsEvaluationResults.Type
    object HumanLoopActivationReason extends Subtype[String]
    type HumanLoopActivationReason =
      zio.aws.rekognition.model.primitives.HumanLoopActivationReason.Type
    object HumanLoopArn extends Subtype[String]
    type HumanLoopArn = zio.aws.rekognition.model.primitives.HumanLoopArn.Type
    object HumanLoopName extends Subtype[String]
    type HumanLoopName = zio.aws.rekognition.model.primitives.HumanLoopName.Type
    object ImageBlob extends Subtype[Chunk[Byte]]
    type ImageBlob = zio.aws.rekognition.model.primitives.ImageBlob.Type
    object ImageId extends Subtype[String]
    type ImageId = zio.aws.rekognition.model.primitives.ImageId.Type
    object IndexFacesModelVersion extends Subtype[String]
    type IndexFacesModelVersion =
      zio.aws.rekognition.model.primitives.IndexFacesModelVersion.Type
    object InferenceUnits extends Subtype[Int]
    type InferenceUnits =
      zio.aws.rekognition.model.primitives.InferenceUnits.Type
    object IsLabeled extends Subtype[Boolean]
    type IsLabeled = zio.aws.rekognition.model.primitives.IsLabeled.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.rekognition.model.primitives.JobId.Type
    object JobTag extends Subtype[String]
    type JobTag = zio.aws.rekognition.model.primitives.JobTag.Type
    object KinesisDataArn extends Subtype[String]
    type KinesisDataArn =
      zio.aws.rekognition.model.primitives.KinesisDataArn.Type
    object KinesisVideoArn extends Subtype[String]
    type KinesisVideoArn =
      zio.aws.rekognition.model.primitives.KinesisVideoArn.Type
    object KinesisVideoStreamFragmentNumber extends Subtype[String]
    type KinesisVideoStreamFragmentNumber =
      zio.aws.rekognition.model.primitives.KinesisVideoStreamFragmentNumber.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.rekognition.model.primitives.KmsKeyId.Type
    object ListDatasetEntriesPageSize extends Subtype[Int]
    type ListDatasetEntriesPageSize =
      zio.aws.rekognition.model.primitives.ListDatasetEntriesPageSize.Type
    object ListDatasetLabelsPageSize extends Subtype[Int]
    type ListDatasetLabelsPageSize =
      zio.aws.rekognition.model.primitives.ListDatasetLabelsPageSize.Type
    object ListProjectPoliciesPageSize extends Subtype[Int]
    type ListProjectPoliciesPageSize =
      zio.aws.rekognition.model.primitives.ListProjectPoliciesPageSize.Type
    object MaxDurationInSecondsULong extends Subtype[Long]
    type MaxDurationInSecondsULong =
      zio.aws.rekognition.model.primitives.MaxDurationInSecondsULong.Type
    object MaxFaces extends Subtype[Int]
    type MaxFaces = zio.aws.rekognition.model.primitives.MaxFaces.Type
    object MaxFacesToIndex extends Subtype[Int]
    type MaxFacesToIndex =
      zio.aws.rekognition.model.primitives.MaxFacesToIndex.Type
    object MaxPixelThreshold extends Subtype[Float]
    type MaxPixelThreshold =
      zio.aws.rekognition.model.primitives.MaxPixelThreshold.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.rekognition.model.primitives.MaxResults.Type
    object MinCoveragePercentage extends Subtype[Float]
    type MinCoveragePercentage =
      zio.aws.rekognition.model.primitives.MinCoveragePercentage.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.rekognition.model.primitives.PageSize.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.rekognition.model.primitives.PaginationToken.Type
    object Percent extends Subtype[Float]
    type Percent = zio.aws.rekognition.model.primitives.Percent.Type
    object PersonIndex extends Subtype[Long]
    type PersonIndex = zio.aws.rekognition.model.primitives.PersonIndex.Type
    object ProjectArn extends Subtype[String]
    type ProjectArn = zio.aws.rekognition.model.primitives.ProjectArn.Type
    object ProjectName extends Subtype[String]
    type ProjectName = zio.aws.rekognition.model.primitives.ProjectName.Type
    object ProjectPolicyDocument extends Subtype[String]
    type ProjectPolicyDocument =
      zio.aws.rekognition.model.primitives.ProjectPolicyDocument.Type
    object ProjectPolicyName extends Subtype[String]
    type ProjectPolicyName =
      zio.aws.rekognition.model.primitives.ProjectPolicyName.Type
    object ProjectPolicyRevisionId extends Subtype[String]
    type ProjectPolicyRevisionId =
      zio.aws.rekognition.model.primitives.ProjectPolicyRevisionId.Type
    object ProjectVersionArn extends Subtype[String]
    type ProjectVersionArn =
      zio.aws.rekognition.model.primitives.ProjectVersionArn.Type
    object ProjectVersionsPageSize extends Subtype[Int]
    type ProjectVersionsPageSize =
      zio.aws.rekognition.model.primitives.ProjectVersionsPageSize.Type
    object ProjectsPageSize extends Subtype[Int]
    type ProjectsPageSize =
      zio.aws.rekognition.model.primitives.ProjectsPageSize.Type
    object QueryString extends Subtype[String]
    type QueryString = zio.aws.rekognition.model.primitives.QueryString.Type
    object RekognitionUniqueId extends Subtype[String]
    type RekognitionUniqueId =
      zio.aws.rekognition.model.primitives.RekognitionUniqueId.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.rekognition.model.primitives.ResourceArn.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.rekognition.model.primitives.RoleArn.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.rekognition.model.primitives.S3Bucket.Type
    object S3KeyPrefix extends Subtype[String]
    type S3KeyPrefix = zio.aws.rekognition.model.primitives.S3KeyPrefix.Type
    object S3ObjectName extends Subtype[String]
    type S3ObjectName = zio.aws.rekognition.model.primitives.S3ObjectName.Type
    object S3ObjectVersion extends Subtype[String]
    type S3ObjectVersion =
      zio.aws.rekognition.model.primitives.S3ObjectVersion.Type
    object SNSTopicArn extends Subtype[String]
    type SNSTopicArn = zio.aws.rekognition.model.primitives.SNSTopicArn.Type
    object SegmentConfidence extends Subtype[Float]
    type SegmentConfidence =
      zio.aws.rekognition.model.primitives.SegmentConfidence.Type
    object StartStreamProcessorSessionId extends Subtype[String]
    type StartStreamProcessorSessionId =
      zio.aws.rekognition.model.primitives.StartStreamProcessorSessionId.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage = zio.aws.rekognition.model.primitives.StatusMessage.Type
    object StreamProcessorArn extends Subtype[String]
    type StreamProcessorArn =
      zio.aws.rekognition.model.primitives.StreamProcessorArn.Type
    object StreamProcessorName extends Subtype[String]
    type StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.rekognition.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.rekognition.model.primitives.TagValue.Type
    object Timecode extends Subtype[String]
    type Timecode = zio.aws.rekognition.model.primitives.Timecode.Type
    object Timestamp extends Subtype[Long]
    type Timestamp = zio.aws.rekognition.model.primitives.Timestamp.Type
    object UInteger extends Subtype[Int]
    type UInteger = zio.aws.rekognition.model.primitives.UInteger.Type
    object ULong extends Subtype[Long]
    type ULong = zio.aws.rekognition.model.primitives.ULong.Type
    object Url extends Subtype[String]
    type Url = zio.aws.rekognition.model.primitives.Url.Type
    object VersionName extends Subtype[String]
    type VersionName = zio.aws.rekognition.model.primitives.VersionName.Type
  }
  type Assets = List[zio.aws.rekognition.model.Asset]
  type Attributes = List[zio.aws.rekognition.model.Attribute]
  type AudioMetadataList = List[zio.aws.rekognition.model.AudioMetadata]
  type BodyParts = List[zio.aws.rekognition.model.ProtectiveEquipmentBodyPart]
  type CelebrityList = List[zio.aws.rekognition.model.Celebrity]
  type CelebrityRecognitions =
    List[zio.aws.rekognition.model.CelebrityRecognition]
  type CollectionIdList = List[CollectionId]
  type CompareFacesMatchList = List[zio.aws.rekognition.model.CompareFacesMatch]
  type CompareFacesUnmatchList = List[zio.aws.rekognition.model.ComparedFace]
  type ComparedFaceList = List[zio.aws.rekognition.model.ComparedFace]
  type ConnectedHomeLabels = List[ConnectedHomeLabel]
  type ContentClassifiers = List[zio.aws.rekognition.model.ContentClassifier]
  type ContentModerationDetections =
    List[zio.aws.rekognition.model.ContentModerationDetection]
  type CustomLabels = List[zio.aws.rekognition.model.CustomLabel]
  type DatasetEntries = List[DatasetEntry]
  type DatasetLabelDescriptions =
    List[zio.aws.rekognition.model.DatasetLabelDescription]
  type DatasetLabels = List[DatasetLabel]
  type DatasetMetadataList = List[zio.aws.rekognition.model.DatasetMetadata]
  type DistributeDatasetMetadataList =
    List[zio.aws.rekognition.model.DistributeDataset]
  type Emotions = List[zio.aws.rekognition.model.Emotion]
  type EquipmentDetections = List[zio.aws.rekognition.model.EquipmentDetection]
  type FaceDetailList = List[zio.aws.rekognition.model.FaceDetail]
  type FaceDetections = List[zio.aws.rekognition.model.FaceDetection]
  type FaceIdList = List[FaceId]
  type FaceList = List[zio.aws.rekognition.model.Face]
  type FaceMatchList = List[zio.aws.rekognition.model.FaceMatch]
  type FaceModelVersionList = List[String]
  type FaceRecordList = List[zio.aws.rekognition.model.FaceRecord]
  type HumanLoopActivationReasons = List[HumanLoopActivationReason]
  type Instances = List[zio.aws.rekognition.model.Instance]
  type LabelDetections = List[zio.aws.rekognition.model.LabelDetection]
  type Labels = List[zio.aws.rekognition.model.Label]
  type Landmarks = List[zio.aws.rekognition.model.Landmark]
  type ModerationLabels = List[zio.aws.rekognition.model.ModerationLabel]
  type Parents = List[zio.aws.rekognition.model.Parent]
  type PersonDetections = List[zio.aws.rekognition.model.PersonDetection]
  type PersonMatches = List[zio.aws.rekognition.model.PersonMatch]
  type Polygon = List[zio.aws.rekognition.model.Point]
  type ProjectDescriptions = List[zio.aws.rekognition.model.ProjectDescription]
  type ProjectNames = List[ProjectName]
  type ProjectPolicies = List[zio.aws.rekognition.model.ProjectPolicy]
  type ProjectVersionDescriptions =
    List[zio.aws.rekognition.model.ProjectVersionDescription]
  type ProtectiveEquipmentPersonIds = List[UInteger]
  type ProtectiveEquipmentPersons =
    List[zio.aws.rekognition.model.ProtectiveEquipmentPerson]
  type ProtectiveEquipmentTypes =
    List[zio.aws.rekognition.model.ProtectiveEquipmentType]
  type Reasons = List[zio.aws.rekognition.model.Reason]
  type RegionsOfInterest = List[zio.aws.rekognition.model.RegionOfInterest]
  type SegmentDetections = List[zio.aws.rekognition.model.SegmentDetection]
  type SegmentTypes = List[zio.aws.rekognition.model.SegmentType]
  type SegmentTypesInfo = List[zio.aws.rekognition.model.SegmentTypeInfo]
  type StreamProcessorList = List[zio.aws.rekognition.model.StreamProcessor]
  type StreamProcessorParametersToDelete =
    List[zio.aws.rekognition.model.StreamProcessorParameterToDelete]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TextDetectionList = List[zio.aws.rekognition.model.TextDetection]
  type TextDetectionResults =
    List[zio.aws.rekognition.model.TextDetectionResult]
  type UnindexedFaces = List[zio.aws.rekognition.model.UnindexedFace]
  type Urls = List[Url]
  type VersionNames = List[VersionName]
  type VideoMetadataList = List[zio.aws.rekognition.model.VideoMetadata]
}
