package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Summary(
    s3Object: Optional[zio.aws.rekognition.model.S3Object] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Summary = {
    import Summary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Summary
      .builder()
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Summary.ReadOnly =
    zio.aws.rekognition.model.Summary.wrap(buildAwsValue())
}
object Summary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Summary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Summary =
      zio.aws.rekognition.model.Summary(s3Object.map(value => value.asEditable))
    def s3Object: Optional[zio.aws.rekognition.model.S3Object.ReadOnly]
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.rekognition.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Summary
  ) extends zio.aws.rekognition.model.Summary.ReadOnly {
    override val s3Object
        : Optional[zio.aws.rekognition.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Object())
        .map(value => zio.aws.rekognition.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Summary
  ): zio.aws.rekognition.model.Summary.ReadOnly = new Wrapper(impl)
}
