package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectPolicyRevisionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutProjectPolicyResponse(
    policyRevisionId: Optional[ProjectPolicyRevisionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse = {
    import PutProjectPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse
      .builder()
      .optionallyWith(
        policyRevisionId.map(value =>
          ProjectPolicyRevisionId.unwrap(value): java.lang.String
        )
      )(_.policyRevisionId)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly =
    zio.aws.rekognition.model.PutProjectPolicyResponse.wrap(buildAwsValue())
}
object PutProjectPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.PutProjectPolicyResponse =
      zio.aws.rekognition.model
        .PutProjectPolicyResponse(policyRevisionId.map(value => value))
    def policyRevisionId: Optional[ProjectPolicyRevisionId]
    def getPolicyRevisionId: ZIO[Any, AwsError, ProjectPolicyRevisionId] =
      AwsError.unwrapOptionField("policyRevisionId", policyRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse
  ) extends zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly {
    override val policyRevisionId: Optional[ProjectPolicyRevisionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyRevisionId())
        .map(value =>
          zio.aws.rekognition.model.primitives.ProjectPolicyRevisionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse
  ): zio.aws.rekognition.model.PutProjectPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
