package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{S3KeyPrefix, S3Bucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputConfig(
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3KeyPrefix: Optional[S3KeyPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.OutputConfig = {
    import OutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.OutputConfig
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3KeyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.OutputConfig.ReadOnly =
    zio.aws.rekognition.model.OutputConfig.wrap(buildAwsValue())
}
object OutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.OutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.OutputConfig =
      zio.aws.rekognition.model.OutputConfig(
        s3Bucket.map(value => value),
        s3KeyPrefix.map(value => value)
      )
    def s3Bucket: Optional[S3Bucket]
    def s3KeyPrefix: Optional[S3KeyPrefix]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.OutputConfig
  ) extends zio.aws.rekognition.model.OutputConfig.ReadOnly {
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.rekognition.model.primitives.S3Bucket(value))
    override val s3KeyPrefix: Optional[S3KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => zio.aws.rekognition.model.primitives.S3KeyPrefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.OutputConfig
  ): zio.aws.rekognition.model.OutputConfig.ReadOnly = new Wrapper(impl)
}
