package zio.aws.rekognition.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{
  IsLabeled,
  DatasetArn,
  DatasetLabel,
  HasErrors,
  QueryString,
  ListDatasetEntriesPageSize,
  ExtendedPaginationToken
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatasetEntriesRequest(
    datasetArn: DatasetArn,
    containsLabels: Optional[Iterable[DatasetLabel]] = Optional.Absent,
    labeled: Optional[IsLabeled] = Optional.Absent,
    sourceRefContains: Optional[QueryString] = Optional.Absent,
    hasErrors: Optional[HasErrors] = Optional.Absent,
    nextToken: Optional[ExtendedPaginationToken] = Optional.Absent,
    maxResults: Optional[ListDatasetEntriesPageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest = {
    import ListDatasetEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
      .builder()
      .datasetArn(DatasetArn.unwrap(datasetArn): java.lang.String)
      .optionallyWith(
        containsLabels.map(value =>
          value.map { item =>
            DatasetLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containsLabels)
      .optionallyWith(
        labeled.map(value => IsLabeled.unwrap(value): java.lang.Boolean)
      )(_.labeled)
      .optionallyWith(
        sourceRefContains.map(value =>
          QueryString.unwrap(value): java.lang.String
        )
      )(_.sourceRefContains)
      .optionallyWith(
        hasErrors.map(value => HasErrors.unwrap(value): java.lang.Boolean)
      )(_.hasErrors)
      .optionallyWith(
        nextToken.map(value =>
          ExtendedPaginationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListDatasetEntriesPageSize.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListDatasetEntriesRequest.ReadOnly =
    zio.aws.rekognition.model.ListDatasetEntriesRequest.wrap(buildAwsValue())
}
object ListDatasetEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListDatasetEntriesRequest =
      zio.aws.rekognition.model.ListDatasetEntriesRequest(
        datasetArn,
        containsLabels.map(value => value),
        labeled.map(value => value),
        sourceRefContains.map(value => value),
        hasErrors.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def datasetArn: DatasetArn
    def containsLabels: Optional[List[DatasetLabel]]
    def labeled: Optional[IsLabeled]
    def sourceRefContains: Optional[QueryString]
    def hasErrors: Optional[HasErrors]
    def nextToken: Optional[ExtendedPaginationToken]
    def maxResults: Optional[ListDatasetEntriesPageSize]
    def getDatasetArn: ZIO[Any, Nothing, DatasetArn] = ZIO.succeed(datasetArn)
    def getContainsLabels: ZIO[Any, AwsError, List[DatasetLabel]] =
      AwsError.unwrapOptionField("containsLabels", containsLabels)
    def getLabeled: ZIO[Any, AwsError, IsLabeled] =
      AwsError.unwrapOptionField("labeled", labeled)
    def getSourceRefContains: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("sourceRefContains", sourceRefContains)
    def getHasErrors: ZIO[Any, AwsError, HasErrors] =
      AwsError.unwrapOptionField("hasErrors", hasErrors)
    def getNextToken: ZIO[Any, AwsError, ExtendedPaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListDatasetEntriesPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
  ) extends zio.aws.rekognition.model.ListDatasetEntriesRequest.ReadOnly {
    override val datasetArn: DatasetArn =
      zio.aws.rekognition.model.primitives.DatasetArn(impl.datasetArn())
    override val containsLabels: Optional[List[DatasetLabel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containsLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.primitives.DatasetLabel(item)
          }.toList
        )
    override val labeled: Optional[IsLabeled] = zio.aws.core.internal
      .optionalFromNullable(impl.labeled())
      .map(value => zio.aws.rekognition.model.primitives.IsLabeled(value))
    override val sourceRefContains: Optional[QueryString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceRefContains())
        .map(value => zio.aws.rekognition.model.primitives.QueryString(value))
    override val hasErrors: Optional[HasErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.hasErrors())
      .map(value => zio.aws.rekognition.model.primitives.HasErrors(value))
    override val nextToken: Optional[ExtendedPaginationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.rekognition.model.primitives.ExtendedPaginationToken(value)
        )
    override val maxResults: Optional[ListDatasetEntriesPageSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.rekognition.model.primitives.ListDatasetEntriesPageSize(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest
  ): zio.aws.rekognition.model.ListDatasetEntriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
