package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait KnownGenderType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.KnownGenderType
}
object KnownGenderType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.KnownGenderType
  ): zio.aws.rekognition.model.KnownGenderType = value match {
    case software.amazon.awssdk.services.rekognition.model.KnownGenderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.KnownGenderType.MALE =>
      val r = Male
      r
    case software.amazon.awssdk.services.rekognition.model.KnownGenderType.FEMALE =>
      val r = Female
      r
    case software.amazon.awssdk.services.rekognition.model.KnownGenderType.NONBINARY =>
      val r = Nonbinary
      r
    case software.amazon.awssdk.services.rekognition.model.KnownGenderType.UNLISTED =>
      val r = Unlisted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.KnownGenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.KnownGenderType =
      software.amazon.awssdk.services.rekognition.model.KnownGenderType.UNKNOWN_TO_SDK_VERSION
  }
  case object Male extends zio.aws.rekognition.model.KnownGenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.KnownGenderType =
      software.amazon.awssdk.services.rekognition.model.KnownGenderType.MALE
  }
  case object Female extends zio.aws.rekognition.model.KnownGenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.KnownGenderType =
      software.amazon.awssdk.services.rekognition.model.KnownGenderType.FEMALE
  }
  case object Nonbinary extends zio.aws.rekognition.model.KnownGenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.KnownGenderType =
      software.amazon.awssdk.services.rekognition.model.KnownGenderType.NONBINARY
  }
  case object Unlisted extends zio.aws.rekognition.model.KnownGenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.KnownGenderType =
      software.amazon.awssdk.services.rekognition.model.KnownGenderType.UNLISTED
  }
}
