package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Instance(
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Instance
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Instance.ReadOnly =
    zio.aws.rekognition.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Instance =
      zio.aws.rekognition.model.Instance(
        boundingBox.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def confidence: Optional[Percent]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Instance
  ) extends zio.aws.rekognition.model.Instance.ReadOnly {
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Instance
  ): zio.aws.rekognition.model.Instance.ReadOnly = new Wrapper(impl)
}
