package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFaceDetectionResponse(
    jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    videoMetadata: Optional[zio.aws.rekognition.model.VideoMetadata] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    faces: Optional[Iterable[zio.aws.rekognition.model.FaceDetection]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse = {
    import GetFaceDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        faces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faces)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly =
    zio.aws.rekognition.model.GetFaceDetectionResponse.wrap(buildAwsValue())
}
object GetFaceDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetFaceDetectionResponse =
      zio.aws.rekognition.model.GetFaceDetectionResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        nextToken.map(value => value),
        faces.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Optional[StatusMessage]
    def videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def faces: Optional[List[zio.aws.rekognition.model.FaceDetection.ReadOnly]]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("faces", faces)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
  ) extends zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly {
    override val jobStatus: Optional[zio.aws.rekognition.model.VideoJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Optional[zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.videoMetadata())
        .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val faces
        : Optional[List[zio.aws.rekognition.model.FaceDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.FaceDetection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse
  ): zio.aws.rekognition.model.GetFaceDetectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
