package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Url
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCelebrityInfoResponse(
    urls: Optional[Iterable[Url]] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    knownGender: Optional[zio.aws.rekognition.model.KnownGender] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse = {
    import GetCelebrityInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse
      .builder()
      .optionallyWith(
        urls.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.urls)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(knownGender.map(value => value.buildAwsValue()))(
        _.knownGender
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly =
    zio.aws.rekognition.model.GetCelebrityInfoResponse.wrap(buildAwsValue())
}
object GetCelebrityInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetCelebrityInfoResponse =
      zio.aws.rekognition.model.GetCelebrityInfoResponse(
        urls.map(value => value),
        name.map(value => value),
        knownGender.map(value => value.asEditable)
      )
    def urls: Optional[List[Url]]
    def name: Optional[String]
    def knownGender: Optional[zio.aws.rekognition.model.KnownGender.ReadOnly]
    def getUrls: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("urls", urls)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getKnownGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.KnownGender.ReadOnly] =
      AwsError.unwrapOptionField("knownGender", knownGender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse
  ) extends zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly {
    override val urls: Optional[List[Url]] = zio.aws.core.internal
      .optionalFromNullable(impl.urls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.Url(item)
        }.toList
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val knownGender
        : Optional[zio.aws.rekognition.model.KnownGender.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.knownGender())
        .map(value => zio.aws.rekognition.model.KnownGender.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse
  ): zio.aws.rekognition.model.GetCelebrityInfoResponse.ReadOnly = new Wrapper(
    impl
  )
}
