package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Geometry(
    boundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    polygon: Optional[Iterable[zio.aws.rekognition.model.Point]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Geometry = {
    import Geometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Geometry
      .builder()
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(
        polygon.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.polygon)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Geometry.ReadOnly =
    zio.aws.rekognition.model.Geometry.wrap(buildAwsValue())
}
object Geometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Geometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Geometry =
      zio.aws.rekognition.model.Geometry(
        boundingBox.map(value => value.asEditable),
        polygon.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def boundingBox: Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def polygon: Optional[List[zio.aws.rekognition.model.Point.ReadOnly]]
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getPolygon
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Point.ReadOnly]] =
      AwsError.unwrapOptionField("polygon", polygon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Geometry
  ) extends zio.aws.rekognition.model.Geometry.ReadOnly {
    override val boundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.boundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val polygon
        : Optional[List[zio.aws.rekognition.model.Point.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.polygon())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Point.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Geometry
  ): zio.aws.rekognition.model.Geometry.ReadOnly = new Wrapper(impl)
}
