package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait GenderType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.GenderType
}
object GenderType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.GenderType
  ): zio.aws.rekognition.model.GenderType = value match {
    case software.amazon.awssdk.services.rekognition.model.GenderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.GenderType.MALE =>
      val r = Male
      r
    case software.amazon.awssdk.services.rekognition.model.GenderType.FEMALE =>
      val r = Female
      r
  }
  case object unknownToSdkVersion extends zio.aws.rekognition.model.GenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.GenderType =
      software.amazon.awssdk.services.rekognition.model.GenderType.UNKNOWN_TO_SDK_VERSION
  }
  case object Male extends zio.aws.rekognition.model.GenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.GenderType =
      software.amazon.awssdk.services.rekognition.model.GenderType.MALE
  }
  case object Female extends zio.aws.rekognition.model.GenderType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.GenderType =
      software.amazon.awssdk.services.rekognition.model.GenderType.FEMALE
  }
}
