package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectProtectiveEquipmentResponse(
    protectiveEquipmentModelVersion: Optional[String] = Optional.Absent,
    persons: Optional[
      Iterable[zio.aws.rekognition.model.ProtectiveEquipmentPerson]
    ] = Optional.Absent,
    summary: Optional[zio.aws.rekognition.model.ProtectiveEquipmentSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse = {
    import DetectProtectiveEquipmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse
      .builder()
      .optionallyWith(
        protectiveEquipmentModelVersion.map(value => value: java.lang.String)
      )(_.protectiveEquipmentModelVersion)
      .optionallyWith(
        persons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.persons)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly =
    zio.aws.rekognition.model.DetectProtectiveEquipmentResponse
      .wrap(buildAwsValue())
}
object DetectProtectiveEquipmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rekognition.model.DetectProtectiveEquipmentResponse =
      zio.aws.rekognition.model.DetectProtectiveEquipmentResponse(
        protectiveEquipmentModelVersion.map(value => value),
        persons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        summary.map(value => value.asEditable)
      )
    def protectiveEquipmentModelVersion: Optional[String]
    def persons: Optional[
      List[zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly]
    ]
    def summary: Optional[
      zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly
    ]
    def getProtectiveEquipmentModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "protectiveEquipmentModelVersion",
        protectiveEquipmentModelVersion
      )
    def getPersons: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly
    ]] = AwsError.unwrapOptionField("persons", persons)
    def getSummary: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly
    ] = AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse
  ) extends zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly {
    override val protectiveEquipmentModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protectiveEquipmentModelVersion())
        .map(value => value: String)
    override val persons: Optional[
      List[zio.aws.rekognition.model.ProtectiveEquipmentPerson.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.persons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ProtectiveEquipmentPerson.wrap(item)
        }.toList
      )
    override val summary: Optional[
      zio.aws.rekognition.model.ProtectiveEquipmentSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.rekognition.model.ProtectiveEquipmentSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse
  ): zio.aws.rekognition.model.DetectProtectiveEquipmentResponse.ReadOnly =
    new Wrapper(impl)
}
