package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStreamProcessorRequest(name: StreamProcessorName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest = {
    import DeleteStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest
      .builder()
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DeleteStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteStreamProcessorRequest.wrap(buildAwsValue())
}
object DeleteStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteStreamProcessorRequest =
      zio.aws.rekognition.model.DeleteStreamProcessorRequest(name)
    def name: StreamProcessorName
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest
  ) extends zio.aws.rekognition.model.DeleteStreamProcessorRequest.ReadOnly {
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest
  ): zio.aws.rekognition.model.DeleteStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
