package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CoversBodyPart(
    confidence: Optional[Percent] = Optional.Absent,
    value: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CoversBodyPart = {
    import CoversBodyPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CoversBodyPart
      .builder()
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(value.map(value => value: java.lang.Boolean))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CoversBodyPart.ReadOnly =
    zio.aws.rekognition.model.CoversBodyPart.wrap(buildAwsValue())
}
object CoversBodyPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CoversBodyPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CoversBodyPart =
      zio.aws.rekognition.model.CoversBodyPart(
        confidence.map(value => value),
        value.map(value => value)
      )
    def confidence: Optional[Percent]
    def value: Optional[Boolean]
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CoversBodyPart
  ) extends zio.aws.rekognition.model.CoversBodyPart.ReadOnly {
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val value: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CoversBodyPart
  ): zio.aws.rekognition.model.CoversBodyPart.ReadOnly = new Wrapper(impl)
}
