package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CompareFacesResponse(
    sourceImageFace: Optional[
      zio.aws.rekognition.model.ComparedSourceImageFace
    ] = Optional.Absent,
    faceMatches: Optional[
      Iterable[zio.aws.rekognition.model.CompareFacesMatch]
    ] = Optional.Absent,
    unmatchedFaces: Optional[Iterable[zio.aws.rekognition.model.ComparedFace]] =
      Optional.Absent,
    sourceImageOrientationCorrection: Optional[
      zio.aws.rekognition.model.OrientationCorrection
    ] = Optional.Absent,
    targetImageOrientationCorrection: Optional[
      zio.aws.rekognition.model.OrientationCorrection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CompareFacesResponse = {
    import CompareFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CompareFacesResponse
      .builder()
      .optionallyWith(sourceImageFace.map(value => value.buildAwsValue()))(
        _.sourceImageFace
      )
      .optionallyWith(
        faceMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceMatches)
      .optionallyWith(
        unmatchedFaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unmatchedFaces)
      .optionallyWith(
        sourceImageOrientationCorrection.map(value => value.unwrap)
      )(_.sourceImageOrientationCorrection)
      .optionallyWith(
        targetImageOrientationCorrection.map(value => value.unwrap)
      )(_.targetImageOrientationCorrection)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CompareFacesResponse.ReadOnly =
    zio.aws.rekognition.model.CompareFacesResponse.wrap(buildAwsValue())
}
object CompareFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CompareFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CompareFacesResponse =
      zio.aws.rekognition.model.CompareFacesResponse(
        sourceImageFace.map(value => value.asEditable),
        faceMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unmatchedFaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceImageOrientationCorrection.map(value => value),
        targetImageOrientationCorrection.map(value => value)
      )
    def sourceImageFace
        : Optional[zio.aws.rekognition.model.ComparedSourceImageFace.ReadOnly]
    def faceMatches
        : Optional[List[zio.aws.rekognition.model.CompareFacesMatch.ReadOnly]]
    def unmatchedFaces
        : Optional[List[zio.aws.rekognition.model.ComparedFace.ReadOnly]]
    def sourceImageOrientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection]
    def targetImageOrientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection]
    def getSourceImageFace: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.ComparedSourceImageFace.ReadOnly
    ] = AwsError.unwrapOptionField("sourceImageFace", sourceImageFace)
    def getFaceMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.CompareFacesMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("faceMatches", faceMatches)
    def getUnmatchedFaces: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ComparedFace.ReadOnly
    ]] = AwsError.unwrapOptionField("unmatchedFaces", unmatchedFaces)
    def getSourceImageOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField(
        "sourceImageOrientationCorrection",
        sourceImageOrientationCorrection
      )
    def getTargetImageOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField(
        "targetImageOrientationCorrection",
        targetImageOrientationCorrection
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CompareFacesResponse
  ) extends zio.aws.rekognition.model.CompareFacesResponse.ReadOnly {
    override val sourceImageFace
        : Optional[zio.aws.rekognition.model.ComparedSourceImageFace.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceImageFace())
        .map(value =>
          zio.aws.rekognition.model.ComparedSourceImageFace.wrap(value)
        )
    override val faceMatches
        : Optional[List[zio.aws.rekognition.model.CompareFacesMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.CompareFacesMatch.wrap(item)
          }.toList
        )
    override val unmatchedFaces
        : Optional[List[zio.aws.rekognition.model.ComparedFace.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unmatchedFaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.ComparedFace.wrap(item)
          }.toList
        )
    override val sourceImageOrientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceImageOrientationCorrection())
        .map(value =>
          zio.aws.rekognition.model.OrientationCorrection.wrap(value)
        )
    override val targetImageOrientationCorrection
        : Optional[zio.aws.rekognition.model.OrientationCorrection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetImageOrientationCorrection())
        .map(value =>
          zio.aws.rekognition.model.OrientationCorrection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CompareFacesResponse
  ): zio.aws.rekognition.model.CompareFacesResponse.ReadOnly = new Wrapper(impl)
}
