package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BoundingBox(
    width: Optional[Float] = Optional.Absent,
    height: Optional[Float] = Optional.Absent,
    left: Optional[Float] = Optional.Absent,
    top: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.BoundingBox = {
    import BoundingBox.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.BoundingBox
      .builder()
      .optionallyWith(width.map(value => value: java.lang.Float))(_.width)
      .optionallyWith(height.map(value => value: java.lang.Float))(_.height)
      .optionallyWith(left.map(value => value: java.lang.Float))(_.left)
      .optionallyWith(top.map(value => value: java.lang.Float))(_.top)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.BoundingBox.ReadOnly =
    zio.aws.rekognition.model.BoundingBox.wrap(buildAwsValue())
}
object BoundingBox {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.BoundingBox
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.BoundingBox =
      zio.aws.rekognition.model.BoundingBox(
        width.map(value => value),
        height.map(value => value),
        left.map(value => value),
        top.map(value => value)
      )
    def width: Optional[Float]
    def height: Optional[Float]
    def left: Optional[Float]
    def top: Optional[Float]
    def getWidth: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("height", height)
    def getLeft: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("left", left)
    def getTop: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("top", top)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.BoundingBox
  ) extends zio.aws.rekognition.model.BoundingBox.ReadOnly {
    override val width: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.width())
      .map(value => value: Float)
    override val height: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.height())
      .map(value => value: Float)
    override val left: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.left())
      .map(value => value: Float)
    override val top: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.top())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.BoundingBox
  ): zio.aws.rekognition.model.BoundingBox.ReadOnly = new Wrapper(impl)
}
