package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.SegmentConfidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTechnicalCueDetectionFilter(
    minSegmentConfidence: Optional[SegmentConfidence] = Optional.Absent,
    blackFrame: Optional[zio.aws.rekognition.model.BlackFrame] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartTechnicalCueDetectionFilter = {
    import StartTechnicalCueDetectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartTechnicalCueDetectionFilter
      .builder()
      .optionallyWith(
        minSegmentConfidence.map(value =>
          SegmentConfidence.unwrap(value): java.lang.Float
        )
      )(_.minSegmentConfidence)
      .optionallyWith(blackFrame.map(value => value.buildAwsValue()))(
        _.blackFrame
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.ReadOnly =
    zio.aws.rekognition.model.StartTechnicalCueDetectionFilter
      .wrap(buildAwsValue())
}
object StartTechnicalCueDetectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartTechnicalCueDetectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartTechnicalCueDetectionFilter =
      zio.aws.rekognition.model.StartTechnicalCueDetectionFilter(
        minSegmentConfidence.map(value => value),
        blackFrame.map(value => value.asEditable)
      )
    def minSegmentConfidence: Optional[SegmentConfidence]
    def blackFrame: Optional[zio.aws.rekognition.model.BlackFrame.ReadOnly]
    def getMinSegmentConfidence: ZIO[Any, AwsError, SegmentConfidence] =
      AwsError.unwrapOptionField("minSegmentConfidence", minSegmentConfidence)
    def getBlackFrame
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BlackFrame.ReadOnly] =
      AwsError.unwrapOptionField("blackFrame", blackFrame)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartTechnicalCueDetectionFilter
  ) extends zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.ReadOnly {
    override val minSegmentConfidence: Optional[SegmentConfidence] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minSegmentConfidence())
        .map(value =>
          zio.aws.rekognition.model.primitives.SegmentConfidence(value)
        )
    override val blackFrame
        : Optional[zio.aws.rekognition.model.BlackFrame.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blackFrame())
        .map(value => zio.aws.rekognition.model.BlackFrame.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartTechnicalCueDetectionFilter
  ): zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.ReadOnly =
    new Wrapper(impl)
}
