package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchFacesByImageResponse(
    searchedFaceBoundingBox: Optional[zio.aws.rekognition.model.BoundingBox] =
      Optional.Absent,
    searchedFaceConfidence: Optional[Percent] = Optional.Absent,
    faceMatches: Optional[Iterable[zio.aws.rekognition.model.FaceMatch]] =
      Optional.Absent,
    faceModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse = {
    import SearchFacesByImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
      .builder()
      .optionallyWith(
        searchedFaceBoundingBox.map(value => value.buildAwsValue())
      )(_.searchedFaceBoundingBox)
      .optionallyWith(
        searchedFaceConfidence.map(value =>
          Percent.unwrap(value): java.lang.Float
        )
      )(_.searchedFaceConfidence)
      .optionallyWith(
        faceMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceMatches)
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly =
    zio.aws.rekognition.model.SearchFacesByImageResponse.wrap(buildAwsValue())
}
object SearchFacesByImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesByImageResponse =
      zio.aws.rekognition.model.SearchFacesByImageResponse(
        searchedFaceBoundingBox.map(value => value.asEditable),
        searchedFaceConfidence.map(value => value),
        faceMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        faceModelVersion.map(value => value)
      )
    def searchedFaceBoundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def searchedFaceConfidence: Optional[Percent]
    def faceMatches
        : Optional[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]]
    def faceModelVersion: Optional[String]
    def getSearchedFaceBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField(
        "searchedFaceBoundingBox",
        searchedFaceBoundingBox
      )
    def getSearchedFaceConfidence: ZIO[Any, AwsError, Percent] = AwsError
      .unwrapOptionField("searchedFaceConfidence", searchedFaceConfidence)
    def getFaceMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("faceMatches", faceMatches)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
  ) extends zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly {
    override val searchedFaceBoundingBox
        : Optional[zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchedFaceBoundingBox())
        .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val searchedFaceConfidence: Optional[Percent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchedFaceConfidence())
        .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val faceMatches
        : Optional[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faceMatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.FaceMatch.wrap(item)
          }.toList
        )
    override val faceModelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.faceModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse
  ): zio.aws.rekognition.model.SearchFacesByImageResponse.ReadOnly =
    new Wrapper(impl)
}
