package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RecognizeCelebritiesRequest(
    image: zio.aws.rekognition.model.Image
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest = {
    import RecognizeCelebritiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest
      .builder()
      .image(image.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.RecognizeCelebritiesRequest.ReadOnly =
    zio.aws.rekognition.model.RecognizeCelebritiesRequest.wrap(buildAwsValue())
}
object RecognizeCelebritiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.RecognizeCelebritiesRequest =
      zio.aws.rekognition.model.RecognizeCelebritiesRequest(image.asEditable)
    def image: zio.aws.rekognition.model.Image.ReadOnly
    def getImage: ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(image)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest
  ) extends zio.aws.rekognition.model.RecognizeCelebritiesRequest.ReadOnly {
    override val image: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.image())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest
  ): zio.aws.rekognition.model.RecognizeCelebritiesRequest.ReadOnly =
    new Wrapper(impl)
}
