package zio.aws.rekognition.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rekognition.model.primitives.{DateTime, ProjectArn}
import scala.jdk.CollectionConverters._
final case class ProjectDescription(
    projectArn: Optional[ProjectArn] = Optional.Absent,
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.rekognition.model.ProjectStatus] = Optional.Absent,
    datasets: Optional[Iterable[zio.aws.rekognition.model.DatasetMetadata]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ProjectDescription = {
    import ProjectDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ProjectDescription
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        datasets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasets)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ProjectDescription.ReadOnly =
    zio.aws.rekognition.model.ProjectDescription.wrap(buildAwsValue())
}
object ProjectDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ProjectDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ProjectDescription =
      zio.aws.rekognition.model.ProjectDescription(
        projectArn.map(value => value),
        creationTimestamp.map(value => value),
        status.map(value => value),
        datasets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def projectArn: Optional[ProjectArn]
    def creationTimestamp: Optional[DateTime]
    def status: Optional[zio.aws.rekognition.model.ProjectStatus]
    def datasets
        : Optional[List[zio.aws.rekognition.model.DatasetMetadata.ReadOnly]]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getStatus: ZIO[Any, AwsError, zio.aws.rekognition.model.ProjectStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDatasets: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.DatasetMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("datasets", datasets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectDescription
  ) extends zio.aws.rekognition.model.ProjectDescription.ReadOnly {
    override val projectArn: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.projectArn())
      .map(value => zio.aws.rekognition.model.primitives.ProjectArn(value))
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.rekognition.model.ProjectStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rekognition.model.ProjectStatus.wrap(value))
    override val datasets
        : Optional[List[zio.aws.rekognition.model.DatasetMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.DatasetMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ProjectDescription
  ): zio.aws.rekognition.model.ProjectDescription.ReadOnly = new Wrapper(impl)
}
