package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  HumanLoopActivationConditionsEvaluationResults,
  HumanLoopActivationReason,
  HumanLoopArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HumanLoopActivationOutput(
    humanLoopArn: Optional[HumanLoopArn] = Optional.Absent,
    humanLoopActivationReasons: Optional[Iterable[HumanLoopActivationReason]] =
      Optional.Absent,
    humanLoopActivationConditionsEvaluationResults: Optional[
      HumanLoopActivationConditionsEvaluationResults
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput = {
    import HumanLoopActivationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput
      .builder()
      .optionallyWith(
        humanLoopArn.map(value => HumanLoopArn.unwrap(value): java.lang.String)
      )(_.humanLoopArn)
      .optionallyWith(
        humanLoopActivationReasons.map(value =>
          value.map { item =>
            HumanLoopActivationReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.humanLoopActivationReasons)
      .optionallyWith(
        humanLoopActivationConditionsEvaluationResults.map(value =>
          HumanLoopActivationConditionsEvaluationResults.unwrap(
            value
          ): java.lang.String
        )
      )(_.humanLoopActivationConditionsEvaluationResults)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.HumanLoopActivationOutput.ReadOnly =
    zio.aws.rekognition.model.HumanLoopActivationOutput.wrap(buildAwsValue())
}
object HumanLoopActivationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.HumanLoopActivationOutput =
      zio.aws.rekognition.model.HumanLoopActivationOutput(
        humanLoopArn.map(value => value),
        humanLoopActivationReasons.map(value => value),
        humanLoopActivationConditionsEvaluationResults.map(value => value)
      )
    def humanLoopArn: Optional[HumanLoopArn]
    def humanLoopActivationReasons: Optional[List[HumanLoopActivationReason]]
    def humanLoopActivationConditionsEvaluationResults
        : Optional[HumanLoopActivationConditionsEvaluationResults]
    def getHumanLoopArn: ZIO[Any, AwsError, HumanLoopArn] =
      AwsError.unwrapOptionField("humanLoopArn", humanLoopArn)
    def getHumanLoopActivationReasons
        : ZIO[Any, AwsError, List[HumanLoopActivationReason]] =
      AwsError.unwrapOptionField(
        "humanLoopActivationReasons",
        humanLoopActivationReasons
      )
    def getHumanLoopActivationConditionsEvaluationResults
        : ZIO[Any, AwsError, HumanLoopActivationConditionsEvaluationResults] =
      AwsError.unwrapOptionField(
        "humanLoopActivationConditionsEvaluationResults",
        humanLoopActivationConditionsEvaluationResults
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput
  ) extends zio.aws.rekognition.model.HumanLoopActivationOutput.ReadOnly {
    override val humanLoopArn: Optional[HumanLoopArn] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLoopArn())
      .map(value => zio.aws.rekognition.model.primitives.HumanLoopArn(value))
    override val humanLoopActivationReasons
        : Optional[List[HumanLoopActivationReason]] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLoopActivationReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.HumanLoopActivationReason(item)
        }.toList
      )
    override val humanLoopActivationConditionsEvaluationResults
        : Optional[HumanLoopActivationConditionsEvaluationResults] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.humanLoopActivationConditionsEvaluationResults()
        )
        .map(value =>
          zio.aws.rekognition.model.primitives
            .HumanLoopActivationConditionsEvaluationResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.HumanLoopActivationOutput
  ): zio.aws.rekognition.model.HumanLoopActivationOutput.ReadOnly = new Wrapper(
    impl
  )
}
